"""
Version information for SlideSnap Studio.
This module provides semantic version information and build date.
"""

import datetime

# Semantic Version
SEMANTIC_VERSION = "0.1.6"

def generate_build_date():
    """
    Generate build date string based on current date and time in format: YYYY.MM.DD.HHMM
    This ensures every build has a unique, chronologically sortable build identifier.
    """
    now = datetime.datetime.now()
    return now.strftime("%Y.%m.%d.%H%M")

# Generate build date
BUILD_DATE = generate_build_date()
#Manually override build date
# BUILD_DATE = "2025.03.05.1430" # Override for testing or specific builds

def get_version():
    """Return the current semantic version string."""
    return SEMANTIC_VERSION

def get_build_date():
    """Return the current build date string."""
    return BUILD_DATE

# For display in About dialog or similar
VERSION_DISPLAY = f"Version {SEMANTIC_VERSION}"
BUILD_DATE_DISPLAY = f"Build Date: {BUILD_DATE}"

if __name__ == "__main__":
    print(f"SlideSnap Studio {VERSION_DISPLAY}")
    print(BUILD_DATE_DISPLAY)
